/*
 * Start with a map file and a list of enclosures and generate am
 * initial database.
 */
#include <unistd.h>
#include <stdio.h>
#include <pthread.h>
#include <errno.h>
#include <netinet/in.h>
#include <sys/stat.h>
#include <sys/types.h>

#include "libfma.h"
#include "lf_fabric.h"
#include "lf_mapper_map.h"
#include "lf_dflt_error.h"
#include "lf_switch.h"
#include "lf_symbols.h"
#include "lf_xbar32.h"
#include "libmyri.h"

void dumpit(struct lf_fabric *fp);

struct lf_fabric *
map_to_fabric(
  struct lf_mapfile *mp)
{
  struct lf_fabric *fp;
  int h;
  int x;

  LF_CALLOC(fp, struct lf_fabric, 1);
  LF_CALLOC(fp->hosts, struct lf_host *, mp->nnic);
  LF_CALLOC(fp->xbars, struct lf_xbar *, mp->nxbar);

  /* create all the hosts */
  for (h=0; h<mp->nnic; ++h) {
    struct lf_host *hp;
    struct lf_nic *nicp;

    nicp = mp->nic[h];

    LF_CALLOC(hp, struct lf_host, 1);
    fp->hosts[h] = hp;

    LF_CALLOC(hp->nics, struct lf_nic *, 1);
    LF_CALLOC(hp->hostname, char, 32);
    sprintf(hp->hostname, "host%04d", h);
    hp->num_nics = 1;
    hp->nics[0] = nicp;

    nicp->host = hp;
  }
  fp->num_hosts = h;

  for (x=0; x<mp->nxbar; ++x) {
    fp->xbars[x] = mp->xbar[x];
    fp->xbars[x]->xbar_id = x;
  }
  fp->num_xbars = x;
  return fp;

 except:
  exit(1);
  return NULL;
}


int
main(
  int argc,
  char **argv)
{
  char *mapfile;
  int c;
  extern char *optarg;
  struct lf_mapfile *mp;
  struct lf_fabric *fp;
  int num_mf;

  lf_init();

  num_mf = 0;
  mapfile = NULL;

  /* parse args list */
  while ((c = getopt(argc, argv, "m:")) != EOF) switch (c) {

  case 'm':	/* map file (input) */
    mapfile = optarg;
    break;

  }

  /* make sure we got a mapfile */
  if (mapfile == NULL) {
    fprintf(stderr, "Need mapfile (-m)\n");
    exit(1);
  }

  /* load the mapper file */
  mp = lf_load_mapper_map(mapfile);
  if (mp == NULL) LF_ERROR(("Loading map file", mapfile));

  /* create a fabric */
  fp = map_to_fabric(mp);

  lf_process_fabric_for_topo(fp);

  dumpit(fp);
  
  exit(0);

 except:
  exit(1);
}

void
dumpit(
  struct lf_fabric *fp)
{
  int i,n;
  int x;

  printf("Fabric loaded, %d hosts\n", fp->num_hosts);
  for (i=0; i<fp->num_hosts; ++i) {
   lf_host_t *hp;
   hp = fp->hosts[i];
   if (hp == NULL) { printf("%d: null\n", i); continue; }
   printf("\"%s\", %d NICs\n", hp->hostname, hp->num_nics);
   for (n=0; n<hp->num_nics;++n) {
     lf_nic_t *np;
     np = hp->nics[n];
     printf("\t%d " LF_MAC_FORMAT " sn=%s, pn=%s\n", n,
       LF_MAC_ARGS(np->mac_addr),
       np->serial_no, np->product_id);
   }
  }

  printf("%d xbars\n", fp->num_xbars);
  for (x=0; x<fp->num_xbars; ++x) {
    struct lf_xbar *xp;
    int p;

    xp = fp->xbars[x];
    printf("      xbar[%d] - xid=%d, %d ports, clos=%d\n", x,
	xp->xbar_id, xp->num_ports,
	xp->clos_level);
	
    for (p=0; p<xp->num_ports; ++p) {
      union lf_node *onp;

      printf("       %d -", p);

      onp = xp->topo_ports[p];
      if (onp == NULL) {
	printf("\n");
	continue;
      }

      if (onp->ln_type == LF_NODE_XBAR) {
	struct lf_xbar *oxp;
	int dif;

	oxp = LF_XBAR(onp);
	printf(" x%d:%d, clos=%d", oxp->xbar_id,
		xp->topo_rports[p], oxp->clos_level);

	dif = oxp->clos_level -  xp->clos_level;
	if (!(dif == -1 || dif == 1)) printf(" XXXX");

      } else if (onp->ln_type == LF_NODE_NIC) {
	struct lf_nic *onicp;
	onicp = LF_NIC(onp);
	printf(" " LF_MAC_FORMAT ":s%d:p%d",
		LF_MAC_ARGS(onicp->mac_addr), onicp->host_nic_id,
	    xp->topo_rports[p]);
	if (xp->clos_level != 1) printf("XXXX\n");
      } else {
	printf(" ????");
      }

      printf(")\n");
    }
  }
}
